/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.peripherals;

import cc.tweaked_programs.cccbridge.blockEntity.SourceBlockEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceBlockPeripheral
implements IPeripheral {
    private final SourceBlockEntity source_block_entity;
    private final Terminal term = new Terminal(4, 2, false);
    private final List<IComputerAccess> pcs = new LinkedList<IComputerAccess>();

    public SourceBlockPeripheral(SourceBlockEntity source_block_entity) {
        this.source_block_entity = source_block_entity;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.pcs.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.pcs.removeIf(p -> p.getID() == computer.getID());
    }

    public void resize() {
        for (IComputerAccess pc : this.pcs) {
            pc.queueEvent("monitor_resize", new Object[]{pc.getAttachmentName()});
        }
    }

    public void setSize(int width, int height) {
        int oldW = this.term.getWidth();
        int oldH = this.term.getHeight();
        if (oldW == width && oldH == height) {
            return;
        }
        this.term.resize(width, height);
        this.resize();
    }

    public List<String> getContent() {
        LinkedList<String> content = new LinkedList<String>();
        for (int i = 0; i < this.term.getHeight(); ++i) {
            Object line = this.term.getLine(i).toString();
            for (int j = 0; j < ((String)line).length(); ++j) {
                char ch = ((String)line).charAt(j);
                if (ch >= ' ' && (ch <= '~' || ch >= '\u00a1')) continue;
                line = ((String)line).substring(0, j) + "?" + ((String)line).substring(j + 1);
            }
            content.add((String)line);
        }
        return content;
    }

    @LuaFunction
    public final void setCursorPos(int x, int y) {
        this.term.setCursorPos(x - 1, y - 1);
    }

    @LuaFunction
    public final void write(String text) {
        this.term.write(text);
        this.term.setCursorPos(this.term.getCursorX() + text.length(), this.term.getCursorY());
    }

    @LuaFunction
    public final void scroll(int yDiff) {
        this.term.scroll(yDiff);
    }

    @LuaFunction
    public final void clear() {
        this.term.clear();
    }

    @LuaFunction
    public final void clearLine() {
        this.term.clearLine();
    }

    @LuaFunction
    public final String getLine(int y) throws LuaException {
        if (y < 1 || y > this.term.getHeight()) {
            throw new LuaException("Expected number in range 1-" + this.term.getHeight());
        }
        TextBuffer line = this.term.getLine(y - 1);
        return line.toString();
    }

    @LuaFunction
    public final Object[] getCursorPos() {
        return new Object[]{this.term.getCursorX() + 1, this.term.getCursorY() + 1};
    }

    @LuaFunction
    public final Object[] getSize() {
        return new Object[]{this.term.getWidth(), this.term.getHeight()};
    }

    @NotNull
    public String getType() {
        return "create_source";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable IPeripheral other) {
        if (this == other) return true;
        if (!(other instanceof SourceBlockPeripheral)) return false;
        SourceBlockPeripheral source = (SourceBlockPeripheral)other;
        if (source.source_block_entity != this.source_block_entity) return false;
        return true;
    }
}

